
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # milligrams of vitamin B9
    x2 = model.addVar(name='x2', lb=0)  # milligrams of vitamin B4
    x3 = model.addVar(name='x3', lb=0)  # grams of fiber
    x4 = model.addVar(name='x4', lb=0)  # milligrams of vitamin K

    # Define the objective function
    model.setObjective(7 * x1 + 8 * x2 + 7 * x3 + 5 * x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11 * x1 <= 79)
    model.addConstr(9 * x2 <= 79)
    model.addConstr(11 * x3 <= 79)
    model.addConstr(3 * x4 <= 79)
    model.addConstr(-8 * x2 + x3 >= 0)
    model.addConstr(9 * x2 + 3 * x4 <= 64)
    model.addConstr(11 * x1 + 9 * x2 <= 75)
    model.addConstr(11 * x1 + 11 * x3 <= 49)
    model.addConstr(11 * x3 + 3 * x4 <= 45)
    model.addConstr(11 * x1 + 3 * x4 <= 30)
    model.addConstr(11 * x1 + 9 * x2 + 11 * x3 + 3 * x4 <= 30)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of vitamin B9: {x1.varValue}')
        print(f'milligrams of vitamin B4: {x2.varValue}')
        print(f'grams of fiber: {x3.varValue}')
        print(f'milligrams of vitamin K: {x4.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
