
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    green_beans = model.addVar(vtype=GRB.INTEGER, name="green_beans")
    cheeseburgers = model.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

    # Set objective function
    model.setObjective(8.05*green_beans**2 + 7.14*green_beans*cheeseburgers + 7.69*cheeseburgers**2 + 2.38*green_beans, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3*green_beans**2 + 4*cheeseburgers**2 >= 13, "c0")
    model.addConstr(3*green_beans + 4*cheeseburgers >= 13, "c1")
    model.addConstr(-5*green_beans**2 + 2*cheeseburgers**2 >= 0, "c2")
    model.addConstr(3*green_beans + 4*cheeseburgers <= 47, "c3")  # Using the provided upper bound for umami index


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('green_beans:', green_beans.x)
        print('cheeseburgers:', cheeseburgers.x)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

