
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="green_beans")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

# Objective function
m.setObjective(8.05*x1**2 + 7.14*x1*x2 + 7.69*x2**2 + 2.38*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(9*x1**2 + 16*x2**2 >= 13, name="umami_index_squared")
m.addConstr(3*x1 + 4*x2 >= 13, name="total_umami_index_min")
m.addConstr(-5*x1**2 + 2*x2**2 >= 0, name="quadratic_constraint")
m.addConstr(3*x1 + 4*x2 <= 44, name="total_umami_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Green Beans: {x1.x}")
    print(f"Cheeseburgers: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
