
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='green_beans', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='cheeseburgers')

    # Set the objective function
    model.setObjective(8.05 * x1**2 + 7.14 * x1 * x2 + 7.69 * x2**2 + 2.38 * x1, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x1**2 + 4 * x2**2 >= 13)
    model.addConstr(3 * x1 + 4 * x2 >= 13)
    model.addConstr(-5 * x1**2 + 2 * x2**2 >= 0)
    model.addConstr(3 * x1 + 4 * x2 <= 44)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Green beans: ', x1.varValue)
        print('Cheeseburgers: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
