
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="pansies", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="cherry_trees", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="agave", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="petunias", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="cucumber_vines", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5.18*x1**2 + 8.58*x1*x2 + 9.54*x3**2 + 7.11*x3*x5 + 7.56*x3, gp.GRB.MAXIMIZE)

# Add the constraints
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x4 >= 0)
m.addConstr(x5 >= 0)

m.addConstr(20*x1 <= 323)
m.addConstr(20*x1 <= 308)
m.addConstr(14*x1 <= 340)
m.addConstr(27*x1 <= 271)

m.addConstr(12*x2 <= 323)
m.addConstr(9*x2 <= 308)
m.addConstr(27*x2 <= 340)
m.addConstr(1*x2 <= 271)

m.addConstr(5*x3 <= 323)
m.addConstr(2*x3 <= 308)
m.addConstr(2*x3 <= 340)
m.addConstr(9*x3 <= 271)

m.addConstr(26*x4 <= 323)
m.addConstr(12*x4 <= 308)
m.addConstr(11*x4 <= 340)
m.addConstr(16*x4 <= 271)

m.addConstr(10*x5 <= 323)
m.addConstr(2*x5 <= 308)
m.addConstr(19*x5 <= 340)
m.addConstr(23*x5 <= 271)

m.addConstr(x1 + x5 >= 27)
m.addConstr(x2 + x3 + x5 >= 56)
m.addConstr(x1 + x3 + x4 >= 56)
m.addConstr(x1 + x2 + x3 >= 56)
m.addConstr(x2**2 + x3**2 + x4**2 >= 56)
m.addConstr(x1 + x3 + x5 >= 56)
m.addConstr(x1 + x4 + x5 >= 56)
m.addConstr(x1**2 + x2**2 + x4**2 >= 56)
m.addConstr(x3**2 + x4**2 + x5**2 >= 56)

# ... Add the rest of the constraints ...

m.addConstr(x1 + x2 + x3 + x4 + x5 <= 274)
m.addConstr(x1 + x2 <= 119)
m.addConstr(x1 + x4 <= 240)
m.addConstr(x1**2 + x5**2 <= 309)
m.addConstr(x3 + x5 <= 84)
m.addConstr(x2 + x3 <= 234)
m.addConstr(x4 + x5 <= 124)
m.addConstr(x3**2 + x4**2 <= 314)
m.addConstr(x1 + x3 <= 274)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("pansies: ", x1.varValue)
    print("cherry_trees: ", x2.varValue)
    print("agave: ", x3.varValue)
    print("petunias: ", x4.varValue)
    print("cucumber_vines: ", x5.varValue)
else:
    print("No solution found")
