
from gurobipy import *

# Create a new model
m = Model("optimization_model")

# Create variables
jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean")
bobby = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby")
paul = m.addVar(lb=0, vtype=GRB.INTEGER, name="paul")
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo")
peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy")
dale = m.addVar(lb=0, vtype=GRB.INTEGER, name="dale")


# Set objective
m.setObjective(2.33*jean + 3.47*bobby + 8.73*paul + 9.74*ringo + 2.58*peggy + 9.88*dale, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*bobby + 2*paul >= 28)
m.addConstr(12*bobby + 14*ringo >= 13)
m.addConstr(14*ringo + 1*peggy >= 22)
m.addConstr(2*paul + 7*dale >= 21)
m.addConstr(12*bobby + 7*dale >= 29)
m.addConstr(12*bobby + 2*paul + 7*dale >= 22)
m.addConstr(2*paul + 1*peggy + 7*dale >= 22)
m.addConstr(2*paul + 14*ringo + 7*dale >= 22)
m.addConstr(11*jean + 2*paul + 14*ringo >= 22)
m.addConstr(11*jean + 12*bobby + 1*peggy >= 22)
# ... (add all other constraints similarly)


# Resource constraints
m.addConstr(11 * jean + 12 * bobby + 2 * paul + 14 * ringo + 1 * peggy + 7 * dale <= 185, "r0")
m.addConstr(6 * jean + 10 * bobby + 4 * paul + 13 * ringo + 11 * peggy + 12 * dale <= 263, "r1")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

