
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
    potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
    rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
    bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
    bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")

    # Set objective function
    m.setObjective(6.84 * chicken_breasts + 8.92 * potatoes + 2.94 * rotisserie_chickens + 8.74 * bagged_salads + 7.66 * bananas, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads >= 36)
    m.addConstr(9 * potatoes + 2 * bagged_salads >= 39)
    m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 26)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 26)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 26)
    m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 44)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 44)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 44)
    m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 42)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 42)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 42)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 42)
    m.addConstr(-10 * potatoes + 2 * bananas >= 0)
    m.addConstr(10 * potatoes - 10 * rotisserie_chickens >= 0)
    m.addConstr(21 * chicken_breasts + 2 * bagged_salads + 13 * bananas <= 68)
    m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas <= 168)
    m.addConstr(21 * chicken_breasts + 14 * rotisserie_chickens + 13 * bananas <= 85)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas <= 160)
    m.addConstr(21 * chicken_breasts + 14 * rotisserie_chickens + 2 * bagged_salads <= 156)
    m.addConstr(9 * potatoes + 14 * rotisserie_chickens + 13 * bananas <= 126)
    m.addConstr(9 * potatoes + 2 * bagged_salads + 13 * bananas <= 78)
    m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens <= 154)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName} = {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
