
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="chicken breasts", lb=0)
x2 = model.addVar(name="potatoes", lb=0)
x3 = model.addVar(name="rotisserie chickens", lb=0)
x4 = model.addVar(name="bagged salads", lb=0)
x5 = model.addVar(name="bananas", lb=0)

# Define the objective function
model.setObjective(6.84 * x1 + 8.92 * x2 + 2.94 * x3 + 8.74 * x4 + 7.66 * x5, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * x3 + 2 * x4 >= 36)
model.addConstr(9 * x2 + 2 * x4 >= 39)
model.addConstr(14 * x3 + 2 * x4 + 13 * x5 >= 26)
model.addConstr(21 * x1 + 9 * x2 + 14 * x3 >= 26)
model.addConstr(21 * x1 + 9 * x2 + 13 * x5 >= 26)
model.addConstr(14 * x3 + 2 * x4 + 13 * x5 >= 44)
model.addConstr(21 * x1 + 9 * x2 + 14 * x3 >= 44)
model.addConstr(21 * x1 + 9 * x2 + 13 * x5 >= 44)
model.addConstr(14 * x3 + 2 * x4 + 13 * x5 >= 42)
model.addConstr(21 * x1 + 9 * x2 + 14 * x3 >= 42)
model.addConstr(21 * x1 + 9 * x2 + 13 * x5 >= 42)
model.addConstr(21 * x1 + 9 * x2 + 14 * x3 + 2 * x4 + 13 * x5 >= 42)
model.addConstr(-10 * x2 + 2 * x5 >= 0)
model.addConstr(10 * x2 - 10 * x3 >= 0)
model.addConstr(21 * x1 + 2 * x4 + 13 * x5 <= 68)
model.addConstr(14 * x3 + 2 * x4 + 13 * x5 <= 168)
model.addConstr(21 * x1 + 14 * x3 + 13 * x5 <= 85)
model.addConstr(21 * x1 + 9 * x2 + 13 * x5 <= 160)
model.addConstr(21 * x1 + 14 * x3 + 2 * x4 <= 156)
model.addConstr(9 * x2 + 14 * x3 + 13 * x5 <= 126)
model.addConstr(9 * x2 + 2 * x4 + 13 * x5 <= 78)
model.addConstr(21 * x1 + 9 * x2 + 14 * x3 <= 154)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Chicken breasts: ", x1.varValue)
    print("Potatoes: ", x2.varValue)
    print("Rotisserie chickens: ", x3.varValue)
    print("Bagged salads: ", x4.varValue)
    print("Bananas: ", x5.varValue)
else:
    print("The model is infeasible")
