
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cheeseburgers = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
cantaloupes = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
protein_bars = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
blueberry_pies = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")


# Set objective function
m.setObjective(8.78 * cheeseburgers + 9.72 * cantaloupes + 6.84 * protein_bars + 3.94 * blueberry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * cantaloupes + 11 * protein_bars >= 32)
m.addConstr(1 * cantaloupes + 12 * blueberry_pies >= 36)
m.addConstr(12 * cheeseburgers + 1 * cantaloupes >= 55)
m.addConstr(12 * cheeseburgers + 1 * cantaloupes + 11 * protein_bars + 12 * blueberry_pies >= 55)
m.addConstr(6 * cheeseburgers + 12 * cantaloupes >= 57)
m.addConstr(8 * protein_bars + 8 * blueberry_pies >= 42)
m.addConstr(6 * cheeseburgers + 8 * protein_bars >= 29)
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars >= 54)
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars + 8 * blueberry_pies >= 54)
m.addConstr(3 * protein_bars + 16 * blueberry_pies >= 20)
m.addConstr(2 * cantaloupes + 3 * protein_bars >= 10)
m.addConstr(2 * cantaloupes + 16 * blueberry_pies >= 24)
m.addConstr(2 * cheeseburgers + 2 * cantaloupes + 3 * protein_bars + 16 * blueberry_pies >= 24)
m.addConstr(-9 * cantaloupes + 10 * blueberry_pies >= 0)
m.addConstr(6 * cheeseburgers - 5 * protein_bars >= 0)
m.addConstr(-9 * cheeseburgers + 7 * blueberry_pies >= 0)
m.addConstr(12 * cheeseburgers + 12 * blueberry_pies <= 117)
m.addConstr(11 * protein_bars + 12 * blueberry_pies <= 181)
m.addConstr(1 * cantaloupes + 11 * protein_bars + 12 * blueberry_pies <= 69)
m.addConstr(12 * cheeseburgers + 1 * cantaloupes + 11 * protein_bars <= 64)
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars <= 230)
m.addConstr(2 * cheeseburgers + 3 * protein_bars <= 82)
m.addConstr(3 * protein_bars + 16 * blueberry_pies <= 39)

# Resource constraints
m.addConstr(12 * cheeseburgers + 1 * cantaloupes + 11 * protein_bars + 12 * blueberry_pies <= 249)
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars + 8 * blueberry_pies <= 231)
m.addConstr(2 * cheeseburgers + 2 * cantaloupes + 3 * protein_bars + 16 * blueberry_pies <= 98)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

