
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # cheeseburgers
    x1 = model.addVar(name="x1", lb=0)  # cantaloupes
    x2 = model.addVar(name="x2", lb=0)  # protein bars
    x3 = model.addVar(name="x3", lb=0)  # blueberry pies

    # Objective function
    model.setObjective(8.78 * x0 + 9.72 * x1 + 6.84 * x2 + 3.94 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12 * x0 + x1 + 11 * x2 + 12 * x3 <= 249)
    model.addConstr(6 * x0 + 12 * x1 + 8 * x2 + 8 * x3 <= 231)
    model.addConstr(2 * x0 + 2 * x1 + 3 * x2 + 16 * x3 <= 98)
    model.addConstr(x1 + 11 * x2 >= 32)
    model.addConstr(x1 + 12 * x3 >= 36)
    model.addConstr(12 * x0 + x1 >= 55)
    model.addConstr(12 * x0 + x1 + 11 * x2 + 12 * x3 >= 55)
    model.addConstr(6 * x0 + 12 * x1 >= 57)
    model.addConstr(8 * x2 + 8 * x3 >= 42)
    model.addConstr(6 * x0 + 8 * x2 >= 29)
    model.addConstr(6 * x0 + 12 * x1 + 8 * x2 >= 54)
    model.addConstr(6 * x0 + 12 * x1 + 8 * x2 + 8 * x3 >= 54)
    model.addConstr(3 * x2 + 16 * x3 >= 20)
    model.addConstr(2 * x1 + 3 * x2 >= 10)
    model.addConstr(2 * x1 + 16 * x3 >= 24)
    model.addConstr(2 * x0 + 2 * x1 + 3 * x2 + 16 * x3 >= 24)
    model.addConstr(-9 * x1 + 10 * x3 >= 0)
    model.addConstr(6 * x0 - 5 * x2 >= 0)
    model.addConstr(-9 * x0 + 7 * x3 >= 0)
    model.addConstr(12 * x0 + 12 * x3 <= 117)
    model.addConstr(11 * x2 + 12 * x3 <= 181)
    model.addConstr(x1 + 11 * x2 + 12 * x3 <= 69)
    model.addConstr(12 * x0 + x1 + 11 * x2 <= 64)
    model.addConstr(6 * x0 + 12 * x1 + 8 * x2 <= 230)
    model.addConstr(2 * x0 + 3 * x2 <= 82)
    model.addConstr(3 * x2 + 16 * x3 <= 39)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("cheeseburgers: ", x0.varValue)
        print("cantaloupes: ", x1.varValue)
        print("protein bars: ", x2.varValue)
        print("blueberry pies: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
