
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    chicken_breasts = m.addVar(vtype=GRB.INTEGER, name="chicken_breasts")
    steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
    lemons = m.addVar(vtype=GRB.INTEGER, name="lemons")


    # Set objective function
    m.setObjective(chicken_breasts**2 + 8*steaks**2 + 5*steaks*lemons + 3*lemons**2 + 5*chicken_breasts, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(steaks**2 + lemons**2 >= 19, "c0")
    m.addConstr(chicken_breasts + lemons >= 11, "c1")
    m.addConstr(8*chicken_breasts**2 - 3*lemons**2 >= 0, "c2")
    m.addConstr(chicken_breasts + steaks <= 62, "c3")
    m.addConstr(steaks + lemons <= 27, "c4")
    m.addConstr(chicken_breasts + lemons <= 32, "c5")
    m.addConstr(chicken_breasts + steaks + lemons <= 32, "c6")
    m.addConstr(chicken_breasts + 6*steaks + 3*lemons <= 70, "c7")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('chicken_breasts:', chicken_breasts.x)
        print('steaks:', steaks.x)
        print('lemons:', lemons.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
