
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="chicken_breasts", vtype=gp.GRB.INTEGER)  # Non-fractional
x2 = m.addVar(name="steaks", vtype=gp.GRB.INTEGER)  # Whole number
x3 = m.addVar(name="lemons", vtype=gp.GRB.INTEGER)  # Whole number

# Objective function
m.setObjective(x1**2 + 8*x2**2 + 5*x2*x3 + 3*x3**2 + 5*x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + 6*x2 + 3*x3 <= 70)  # Total umami index
m.addConstr(6*x2**2 + 3*x3**2 >= 19)  # Minimum umami from steaks and lemons squared
m.addConstr(x1 + 3*x3 >= 11)  # Minimum umami from chicken breasts and lemons
m.addConstr(8*x1**2 - 3*x3**2 >= 0)  # Constraint on chicken breasts and lemons squared
m.addConstr(x1 + 6*x2 <= 62)  # Maximum umami from chicken breasts and steaks
m.addConstr(6*x2 + 3*x3 <= 27)  # Maximum umami from steaks and lemons
m.addConstr(x1 + 3*x3 <= 32)  # Maximum umami from chicken breasts and lemons
m.addConstr(x1 + 6*x2 + 3*x3 <= 32)  # Maximum total umami index

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chicken breasts: {x1.varValue}")
    print(f"Steaks: {x2.varValue}")
    print(f"Lemons: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
