
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
lightbulbs = model.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
rubber_gloves = model.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
packs_of_napkins = model.addVar(vtype=gp.GRB.INTEGER, name="packs_of_napkins")
diapers = model.addVar(vtype=gp.GRB.INTEGER, name="diapers")
cookies = model.addVar(vtype=gp.GRB.INTEGER, name="cookies")

# Set objective function
model.setObjective(9 * lightbulbs + 8 * rubber_gloves + 9 * packs_of_napkins + 4 * diapers + 1 * cookies, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(25 * rubber_gloves + 2 * packs_of_napkins >= 77)
model.addConstr(7 * lightbulbs + 2 * cookies >= 50)
model.addConstr(25 * rubber_gloves + 2 * cookies >= 41)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves >= 63)
model.addConstr(7 * lightbulbs + 19 * diapers >= 101)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies >= 66)
model.addConstr(25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers >= 66)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies >= 88)
model.addConstr(25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers >= 88)
model.addConstr(19 * diapers + 2 * cookies <= 335)
model.addConstr(25 * rubber_gloves + 2 * packs_of_napkins <= 292)
model.addConstr(25 * rubber_gloves + 19 * diapers <= 451)
model.addConstr(7 * lightbulbs + 19 * diapers <= 273)
model.addConstr(7 * lightbulbs + 2 * packs_of_napkins <= 249)
model.addConstr(2 * packs_of_napkins + 19 * diapers <= 459)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves <= 122)
model.addConstr(25 * rubber_gloves + 2 * cookies <= 389)
model.addConstr(7 * lightbulbs + 2 * cookies <= 388)
model.addConstr(7 * lightbulbs + 2 * packs_of_napkins + 2 * cookies <= 428)
model.addConstr(25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers <= 453)
model.addConstr(25 * rubber_gloves + 19 * diapers + 2 * cookies <= 442)
model.addConstr(7 * lightbulbs + 19 * diapers + 2 * cookies <= 364)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies <= 371)
model.addConstr(7 * lightbulbs + 2 * packs_of_napkins + 19 * diapers <= 419)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * packs_of_napkins <= 422)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves + 19 * diapers <= 368)
model.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers + 2 * cookies <= 368)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lightbulbs: {lightbulbs.x}")
    print(f"Rubber Gloves: {rubber_gloves.x}")
    print(f"Packs of Napkins: {packs_of_napkins.x}")
    print(f"Diapers: {diapers.x}")
    print(f"Cookies: {cookies.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

