
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='lightbulbs', vtype='I')
x2 = model.addVar(name='rubber gloves', vtype='I')
x3 = model.addVar(name='packs of napkins', vtype='I')
x4 = model.addVar(name='diapers', vtype='I')
x5 = model.addVar(name='cookies', vtype='I')

# Define the objective function
model.setObjective(9 * x1 + 8 * x2 + 9 * x3 + 4 * x4 + x5, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(25 * x2 + 2 * x3 >= 77)
model.addConstr(7 * x1 + 2 * x5 >= 50)
model.addConstr(25 * x2 + 2 * x5 >= 41)
model.addConstr(7 * x1 + 25 * x2 >= 63)
model.addConstr(7 * x1 + 19 * x4 >= 101)
model.addConstr(7 * x1 + 25 * x2 + 2 * x5 >= 66)
model.addConstr(25 * x2 + 2 * x3 + 19 * x4 >= 66)
model.addConstr(7 * x1 + 25 * x2 + 2 * x5 >= 88)
model.addConstr(25 * x2 + 2 * x3 + 19 * x4 >= 88)
model.addConstr(19 * x4 + 2 * x5 <= 335)
model.addConstr(25 * x2 + 2 * x3 <= 292)
model.addConstr(25 * x2 + 19 * x4 <= 451)
model.addConstr(7 * x1 + 19 * x4 <= 273)
model.addConstr(7 * x1 + 2 * x3 <= 249)
model.addConstr(2 * x3 + 19 * x4 <= 459)
model.addConstr(7 * x1 + 25 * x2 <= 122)
model.addConstr(25 * x2 + 2 * x5 <= 389)
model.addConstr(7 * x1 + 2 * x5 <= 388)
model.addConstr(7 * x1 + 2 * x3 + 2 * x5 <= 428)
model.addConstr(25 * x2 + 2 * x3 + 19 * x4 <= 453)
model.addConstr(25 * x2 + 19 * x4 + 2 * x5 <= 442)
model.addConstr(7 * x1 + 19 * x4 + 2 * x5 <= 364)
model.addConstr(7 * x1 + 25 * x2 + 2 * x5 <= 371)
model.addConstr(7 * x1 + 2 * x3 + 19 * x4 <= 419)
model.addConstr(7 * x1 + 25 * x2 + 2 * x3 <= 422)
model.addConstr(7 * x1 + 25 * x2 + 19 * x4 <= 368)
model.addConstr(7 * x1 + 25 * x2 + 2 * x3 + 19 * x4 + 2 * x5 <= 368)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Lightbulbs: ', x1.varValue)
    print('Rubber gloves: ', x2.varValue)
    print('Packs of napkins: ', x3.varValue)
    print('Diapers: ', x4.varValue)
    print('Cookies: ', x5.varValue)
else:
    print('No solution found')
