
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")

# Set objective function
m.setObjective(9 * milkshakes + 4 * oreos + 9 * bowls_of_pasta + 5 * apple_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20.74 * bowls_of_pasta + 14.49 * apple_pies >= 87)
m.addConstr(13.58 * oreos + 14.49 * apple_pies >= 68)
m.addConstr(23.23 * milkshakes + 20.74 * bowls_of_pasta >= 104)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 14.49 * apple_pies >= 69)
m.addConstr(10.41 * bowls_of_pasta + 23.66 * apple_pies >= 16)
m.addConstr(13.58 * oreos + 20.74 * bowls_of_pasta <= 277)
m.addConstr(23.23 * milkshakes + 13.58 * oreos <= 387)
m.addConstr(23.23 * milkshakes + 20.74 * bowls_of_pasta <= 295)
m.addConstr(20.74 * bowls_of_pasta + 14.49 * apple_pies <= 137)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 14.49 * apple_pies <= 331)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 20.74 * bowls_of_pasta <= 256)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 20.74 * bowls_of_pasta + 14.49 * apple_pies <= 256)
m.addConstr(20.53 * milkshakes + 10.41 * bowls_of_pasta <= 68)
m.addConstr(11.23 * oreos + 23.66 * apple_pies <= 107)
m.addConstr(10.41 * bowls_of_pasta + 23.66 * apple_pies <= 50)
m.addConstr(20.53 * milkshakes + 23.66 * apple_pies <= 133)
m.addConstr(11.23 * oreos + 10.41 * bowls_of_pasta + 23.66 * apple_pies <= 61)
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 10.41 * bowls_of_pasta <= 143)
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 23.66 * apple_pies <= 157)
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 10.41 * bowls_of_pasta + 23.66 * apple_pies <= 157)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

