
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milkshakes", lb=0)
x1 = model.addVar(name="oreos", lb=0)
x2 = model.addVar(name="bowls of pasta", lb=0)
x3 = model.addVar(name="apple pies", lb=0)

# Define the objective function
model.setObjective(9*x0 + 4*x1 + 9*x2 + 5*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20.74*x2 + 14.49*x3 >= 87)
model.addConstr(13.58*x1 + 14.49*x3 >= 68)
model.addConstr(23.23*x0 + 20.74*x2 >= 104)
model.addConstr(23.23*x0 + 13.58*x1 + 14.49*x3 >= 69)
model.addConstr(10.41*x2 + 23.66*x3 >= 16)
model.addConstr(13.58*x1 + 20.74*x2 <= 277)
model.addConstr(23.23*x0 + 13.58*x1 <= 387)
model.addConstr(23.23*x0 + 20.74*x2 <= 295)
model.addConstr(20.74*x2 + 14.49*x3 <= 137)
model.addConstr(23.23*x0 + 13.58*x1 + 14.49*x3 <= 331)
model.addConstr(23.23*x0 + 13.58*x1 + 20.74*x2 <= 256)
model.addConstr(23.23*x0 + 13.58*x1 + 20.74*x2 + 14.49*x3 <= 256)
model.addConstr(20.53*x0 + 10.41*x2 <= 68)
model.addConstr(11.23*x1 + 23.66*x3 <= 107)
model.addConstr(10.41*x2 + 23.66*x3 <= 50)
model.addConstr(20.53*x0 + 23.66*x3 <= 133)
model.addConstr(11.23*x1 + 10.41*x2 + 23.66*x3 <= 61)
model.addConstr(20.53*x0 + 11.23*x1 + 10.41*x2 <= 143)
model.addConstr(20.53*x0 + 11.23*x1 + 23.66*x3 <= 157)
model.addConstr(20.53*x0 + 11.23*x1 + 10.41*x2 + 23.66*x3 <= 157)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Milkshakes: ", x0.varValue)
    print("Oreos: ", x1.varValue)
    print("Bowls of pasta: ", x2.varValue)
    print("Apple pies: ", x3.varValue)
else:
    print("The model is infeasible")
