
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    oreos = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
    kiwis = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")
    pizza_slices = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pizza_slices")


    # Set objective function
    model.setObjective(8 * oreos + 8 * kiwis + 7 * pizza_slices, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1 * oreos + 12 * pizza_slices >= 61, "c0")
    model.addConstr(1 * oreos + 23 * kiwis >= 90, "c1")
    model.addConstr(1 * oreos + 23 * kiwis + 12 * pizza_slices >= 74, "c2")
    model.addConstr(7 * kiwis + 6 * pizza_slices >= 59, "c3")
    model.addConstr(22 * oreos + 7 * kiwis + 6 * pizza_slices >= 59, "c4")
    model.addConstr(-8 * kiwis + 7 * pizza_slices >= 0, "c5")
    model.addConstr(3 * oreos - 4 * kiwis >= 0, "c6")
    model.addConstr(-4 * oreos + 5 * pizza_slices >= 0, "c7")
    model.addConstr(23 * kiwis + 12 * pizza_slices <= 170, "c8")
    model.addConstr(1 * oreos + 23 * kiwis <= 358, "c9")
    model.addConstr(22 * oreos + 6 * pizza_slices <= 115, "c10")
    model.addConstr(1 * oreos <= 429, "c11")
    model.addConstr(22 * oreos + 7 * kiwis + 6 * pizza_slices <= 316, "c12")



    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('oreos:', oreos.x)
        print('kiwis:', kiwis.x)
        print('pizza_slices:', pizza_slices.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
