
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="oreos", lb=0)
    x1 = model.addVar(name="kiwis", lb=0)
    x2 = model.addVar(name="slices of pizza", lb=0)

    # Define the objective function
    model.setObjective(8*x0 + 8*x1 + 7*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x0 + 12*x2 >= 61)
    model.addConstr(x0 + 23*x1 >= 90)
    model.addConstr(x0 + 23*x1 + 12*x2 >= 74)
    model.addConstr(7*x1 + 6*x2 >= 59)
    model.addConstr(22*x0 + 7*x1 + 6*x2 >= 59)
    model.addConstr(-8*x1 + 7*x2 >= 0)
    model.addConstr(3*x0 - 4*x1 >= 0)
    model.addConstr(-4*x0 + 5*x2 >= 0)
    model.addConstr(23*x1 + 12*x2 <= 170)
    model.addConstr(x0 + 23*x1 <= 358)
    model.addConstr(22*x0 + 6*x2 <= 115)

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oreos: {x0.varValue}")
        print(f"Kiwis: {x1.varValue}")
        print(f"Slices of pizza: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
