
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_work_hours")

# Create variables
laura = m.addVar(vtype=gp.GRB.INTEGER, name="laura")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")
bill = m.addVar(vtype=gp.GRB.INTEGER, name="bill")
jean = m.addVar(vtype=gp.GRB.INTEGER, name="jean")
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")


# Set objective function
m.setObjective(1.33 * laura + 9.08 * paul + 5.41 * george + 4.57 * bill + 2.75 * jean + 7.44 * hank, gp.GRB.MINIMIZE)

# Add constraints

m.addConstr(9 * paul + 5 * jean >= 37)
m.addConstr(5 * jean + 9 * hank >= 39)
m.addConstr(6 * laura + 2 * bill >= 17)
m.addConstr(6 * laura + 11 * george >= 29)
m.addConstr(6 * laura + 9 * paul >= 13)
m.addConstr(6 * laura + 9 * hank >= 29)
m.addConstr(6 * laura + 5 * jean >= 17)
m.addConstr(11 * george + 9 * hank >= 30)
m.addConstr(9 * paul + 11 * george >= 29)
m.addConstr(6 * laura + 11 * george + 9 * hank >= 29)
m.addConstr(6 * laura + 9 * paul + 11 * george + 2 * bill + 5 * jean + 9 * hank >= 29)
m.addConstr(9 * laura + 10 * paul >= 16)
m.addConstr(9 * george + 1 * hank >= 28)
m.addConstr(9 * laura + 9 * george >= 16)

# ... (The rest of the constraints from the JSON "constraints" field)
# Add the remaining constraints here in a similar fashion as above.

m.addConstr(6 * laura + 5 * jean <= 89)
m.addConstr(6 * laura + 9 * hank <= 68)
m.addConstr(6 * laura + 9 * paul <= 191)
m.addConstr(11 * george + 2 * bill + 5 * jean <= 54)
m.addConstr(6 * laura + 11 * george + 9 * hank <= 151)
m.addConstr(6 * laura + 11 * george + 2 * bill <= 148)
m.addConstr(11 * george + 5 * jean + 9 * hank <= 70)
m.addConstr(6 * laura + 9 * paul + 2 * bill <= 182)
m.addConstr(9 * laura + 9 * george <= 120)
m.addConstr(10 * paul + 6 * bill + 1 * hank <= 112)
m.addConstr(10 * paul + 9 * george + 7 * jean <= 114)
m.addConstr(9 * laura + 6 * bill + 7 * jean <= 197)
m.addConstr(9 * george + 7 * jean + 1 * hank <= 43)
m.addConstr(10 * paul + 9 * george + 6 * bill <= 42)
m.addConstr(10 * paul + 9 * george + 1 * hank <= 92)
m.addConstr(9 * laura + 10 * paul + 9 * george <= 69)
m.addConstr(-4 * laura + 2 * george >= 0)
m.addConstr(-4 * paul + 3 * jean >= 0)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
