
import gurobi

def create_and_solve_model():
    model = gurobi.Model()

    x0 = model.addVar(name="hamburgers", lb=0)
    x1 = model.addVar(name="eggs", lb=0)
    x2 = model.addVar(name="protein_bars", lb=0)
    x3 = model.addVar(name="pickles", lb=0)

    model.setObjective(5 * x0 + x1 + 7 * x2 + 6 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11 * x0 <= 159)
    model.addConstr(8 * x0 + 14 * x1 + x2 + 4 * x3 <= 87)
    model.addConstr(5 * x0 + 11 * x1 + 10 * x2 + 7 * x3 <= 132)
    model.addConstr(7 * x1 + x3 >= 14)
    model.addConstr(7 * x1 + 7 * x2 >= 34)
    model.addConstr(11 * x0 + 7 * x1 >= 22)
    model.addConstr(x2 + 4 * x3 >= 20)
    model.addConstr(14 * x1 + x2 >= 14)
    model.addConstr(8 * x0 + 4 * x3 >= 9)
    model.addConstr(14 * x1 + x2 + 4 * x3 >= 21)
    model.addConstr(8 * x0 + x2 + 4 * x3 >= 21)
    model.addConstr(8 * x0 + 14 * x1 + x2 >= 21)
    model.addConstr(8 * x0 + 14 * x1 + 4 * x3 >= 21)
    model.addConstr(14 * x1 + x2 + 4 * x3 >= 10)
    model.addConstr(8 * x0 + x2 + 4 * x3 >= 10)
    model.addConstr(8 * x0 + 14 * x1 + x2 >= 10)
    model.addConstr(8 * x0 + 14 * x1 + 4 * x3 >= 10)
    model.addConstr(14 * x1 + x2 + 4 * x3 >= 15)
    model.addConstr(8 * x0 + x2 + 4 * x3 >= 15)
    model.addConstr(8 * x0 + 14 * x1 + x2 >= 15)
    model.addConstr(8 * x0 + 14 * x1 + 4 * x3 >= 15)
    model.addConstr(14 * x1 + x2 + 4 * x3 >= 15)
    model.addConstr(8 * x0 + x2 + 4 * x3 >= 15)
    model.addConstr(8 * x0 + 14 * x1 + x2 >= 15)
    model.addConstr(8 * x0 + 14 * x1 + 4 * x3 >= 15)
    model.addConstr(11 * x1 + 7 * x3 >= 28)
    model.addConstr(5 * x0 + 10 * x2 >= 17)
    model.addConstr(5 * x0 + 7 * x3 >= 28)
    model.addConstr(11 * x0 + x3 <= 68)
    model.addConstr(7 * x1 + x3 <= 46)
    model.addConstr(11 * x0 + 7 * x2 + x3 <= 61)
    model.addConstr(11 * x0 + 7 * x1 + 7 * x2 <= 39)
    model.addConstr(11 * x0 + 7 * x1 + 7 * x2 + x3 <= 39)
    model.addConstr(14 * x1 + x2 <= 41)
    model.addConstr(8 * x0 + x2 <= 31)
    model.addConstr(x2 + 4 * x3 <= 56)
    model.addConstr(8 * x0 + 14 * x1 <= 40)
    model.addConstr(8 * x0 + 14 * x1 + x2 <= 41)
    model.addConstr(8 * x0 + 14 * x1 + x2 + 4 * x3 <= 41)
    model.addConstr(5 * x0 + 11 * x1 <= 55)
    model.addConstr(5 * x0 + 10 * x2 + 7 * x3 <= 99)
    model.addConstr(5 * x0 + 11 * x1 + 7 * x3 <= 101)
    model.addConstr(5 * x0 + 11 * x1 + 10 * x2 + 7 * x3 <= 101)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("hamburgers: ", x0.varValue)
        print("eggs: ", x1.varValue)
        print("protein_bars: ", x2.varValue)
        print("pickles: ", x3.varValue)
    else:
        print("No optimal solution found")

create_and_solve_model()
