
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    napkins = m.addVar(vtype=gp.GRB.INTEGER, name="napkins")
    candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
    lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")


    # Set objective function
    m.setObjective(8*napkins + 7*candles + 3*lightbulbs, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*napkins + 8*candles >= 19, "c1")
    m.addConstr(8*candles + 3*lightbulbs >= 17, "c2")
    m.addConstr(8*napkins + 8*candles + 3*lightbulbs >= 17, "c3")
    m.addConstr(2*candles + 10*lightbulbs >= 17, "c4")
    m.addConstr(9*napkins + 2*candles + 10*lightbulbs >= 15, "c5")
    m.addConstr(2*napkins + 5*candles >= 11, "c6")
    m.addConstr(2*napkins + 6*lightbulbs >= 8, "c7")
    m.addConstr(2*napkins + 5*candles + 6*lightbulbs >= 22, "c8")
    m.addConstr(-7*napkins + 8*lightbulbs >= 0, "c9")
    m.addConstr(-9*candles + 9*lightbulbs >= 0, "c10")
    m.addConstr(2*candles + 10*lightbulbs <= 75, "c11")
    m.addConstr(9*napkins + 2*candles <= 60, "c12")
    m.addConstr(2*napkins + 5*candles + 6*lightbulbs <= 42, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('napkins:', napkins.x)
        print('candles:', candles.x)
        print('lightbulbs:', lightbulbs.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
