
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # packs of napkins
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # candles
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # lightbulbs

    # Objective function
    model.setObjective(8 * x0 + 7 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * x0 + 8 * x1 + 3 * x2 >= 17)
    model.addConstr(8 * x0 + 8 * x1 >= 19)
    model.addConstr(8 * x1 + 3 * x2 >= 17)
    model.addConstr(9 * x0 + 2 * x1 + 10 * x2 >= 15)
    model.addConstr(2 * x1 + 10 * x2 >= 17)
    model.addConstr(2 * x0 + 5 * x1 + 6 * x2 >= 22)
    model.addConstr(2 * x0 + 5 * x1 >= 11)
    model.addConstr(2 * x0 + 6 * x2 >= 8)
    model.addConstr(-7 * x0 + 8 * x2 >= 0)
    model.addConstr(-9 * x1 + 9 * x2 >= 0)
    model.addConstr(2 * x1 + 10 * x2 <= 75)
    model.addConstr(9 * x0 + 2 * x1 <= 60)
    model.addConstr(2 * x0 + 5 * x1 + 6 * x2 <= 42)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
