
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
    b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12")


    # Set objective function
    m.setObjective(9 * iron + 2 * b12, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9 * iron + 8 * b12 >= 18, "c0")
    m.addConstr(6 * iron + 7 * b12 >= 34, "c1")
    m.addConstr(14 * iron + 8 * b12 >= 17, "c2")
    m.addConstr(13 * iron + 12 * b12 >= 68, "c3")
    m.addConstr(3 * iron - 3 * b12 >= 0, "c4")
    m.addConstr(9 * iron + 8 * b12 <= 30, "c5")
    m.addConstr(6 * iron + 7 * b12 <= 108, "c6")
    m.addConstr(14 * iron + 8 * b12 <= 38, "c7")
    m.addConstr(13 * iron + 12 * b12 <= 140, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('iron:', iron.x)
        print('b12:', b12.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
