
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_iron", lb=0)  # Assuming no lower bound for simplicity
    x2 = model.addVar(name="milligrams_of_vitamin_B12", lb=0)  # Assuming no lower bound for simplicity

    # Define the objective function
    model.setObjective(9 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(9 * x1 + 8 * x2 >= 18)
    model.addConstr(6 * x1 + 7 * x2 >= 34)
    model.addConstr(14 * x1 + 8 * x2 >= 17)
    model.addConstr(13 * x1 + 12 * x2 >= 68)
    model.addConstr(3 * x1 - 3 * x2 >= 0)
    model.addConstr(9 * x1 + 8 * x2 <= 30)
    model.addConstr(6 * x1 + 7 * x2 <= 108)
    model.addConstr(14 * x1 + 8 * x2 <= 38)
    model.addConstr(13 * x1 + 12 * x2 <= 140)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Milligrams of vitamin B12: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
