
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
    cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
    lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")


    # Set objective function
    m.setObjective(8*oreos + 9*cheeseburgers + 9*lemons, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9*oreos + 19*lemons >= 23, "c0")
    m.addConstr(7*cheeseburgers + 1*lemons >= 15, "c1")
    m.addConstr(7*cheeseburgers + 19*lemons <= 79, "c2")
    m.addConstr(9*oreos + 7*cheeseburgers <= 120, "c3")
    m.addConstr(9*oreos + 7*cheeseburgers + 19*lemons <= 120, "c4")
    m.addConstr(1*oreos + 7*cheeseburgers <= 95, "c5")
    m.addConstr(7*cheeseburgers + 1*lemons <= 35, "c6")
    m.addConstr(1*oreos + 7*cheeseburgers + 1*lemons <= 35, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('oreos:', oreos.x)
        print('cheeseburgers:', cheeseburgers.x)
        print('lemons:', lemons.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
