
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="oreos", lb=0)
x1 = model.addVar(name="cheeseburgers", lb=0)
x2 = model.addVar(name="lemons", lb=0)

# Define the objective function
model.setObjective(8*x0 + 9*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(9*x0 + 19*x2 >= 23, name="sourness_oreos_lemons")
model.addConstr(7*x1 + x2 >= 15, name="fiber_cheeseburgers_lemons")
model.addConstr(7*x1 + 19*x2 <= 79, name="sourness_cheeseburgers_lemons")
model.addConstr(9*x0 + 7*x1 <= 120, name="sourness_oreos_cheeseburgers")
model.addConstr(9*x0 + 7*x1 + 19*x2 <= 120, name="sourness_all")
model.addConstr(x0 + 7*x1 <= 95, name="fiber_oreos_cheeseburgers")
model.addConstr(7*x1 + x2 <= 35, name="fiber_cheeseburgers_lemons")
model.addConstr(x0 + 7*x1 + x2 <= 35, name="fiber_all")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Oreos: ", x0.varValue)
    print("Cheeseburgers: ", x1.varValue)
    print("Lemons: ", x2.varValue)
else:
    print("The model is infeasible")
