
from gurobipy import Model, GRB

# Create a new model
m = Model("work_optimization")

# Create variables
bobby_hours = m.addVar(vtype=GRB.INTEGER, name="bobby_hours")
bill_hours = m.addVar(vtype=GRB.INTEGER, name="bill_hours")


# Set objective function
m.setObjective(5 * bobby_hours + 7 * bill_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.16 * bobby_hours + 5.77 * bill_hours >= 8, "quality_min")
m.addConstr(-4 * bobby_hours + 5 * bill_hours >= 0, "hours_relation")
m.addConstr(14.16 * bobby_hours + 5.77 * bill_hours <= 39, "quality_max")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Bobby hours:', bobby_hours.x)
    print('Bill hours:', bill_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

