
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.16*x1 + 5.77*x2 >= 8, "Work_Quality_Min")
m.addConstr(-4*x1 + 5*x2 >= 0, "Balance_Constraint")
m.addConstr(14.16*x1 + 5.77*x2 <= 39, "Work_Quality_Max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
