
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Bobby", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Bill", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5 * x1 + 7 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(14.16 * x1 + 5.77 * x2 >= 8, name="work_quality_rating_constraint1")
m.addConstr(-4 * x1 + 5 * x2 >= 0, name="work_quality_rating_constraint2")
m.addConstr(14.16 * x1 + 5.77 * x2 <= 39, name="work_quality_rating_constraint3")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bobby: {x1.varValue}")
    print(f"Hours worked by Bill: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
