
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    cheeseburgers = m.addVar(vtype=gp.GRB.INTEGER, name="cheeseburgers")
    tomatoes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tomatoes")
    milkshakes = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")

    # Set objective function
    m.setObjective(cheeseburgers**2 + cheeseburgers * milkshakes + 9 * tomatoes**2 + 4 * milkshakes, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12 * cheeseburgers + tomatoes + 11 * milkshakes <= 66, "c0")
    m.addConstr(7 * cheeseburgers + 6 * tomatoes + 2 * milkshakes <= 55, "c1")
    m.addConstr(2 * cheeseburgers + 3 * tomatoes + 9 * milkshakes <= 62, "c2")
    m.addConstr(6 * tomatoes + 2 * milkshakes >= 15, "c3")
    m.addConstr(tomatoes + 11 * milkshakes <= 46, "c4")
    m.addConstr(12 * cheeseburgers + tomatoes <= 25, "c5")
    m.addConstr(12 * cheeseburgers + tomatoes + 11 * milkshakes <= 25, "c6")
    m.addConstr(7 * cheeseburgers + 6 * tomatoes <= 23, "c7")
    m.addConstr(7 * cheeseburgers + 2 * milkshakes <= 41, "c8")
    m.addConstr(7 * cheeseburgers**2 + 6 * tomatoes**2 + 2 * milkshakes**2 <= 21, "c9")
    m.addConstr(7 * cheeseburgers + 6 * tomatoes + 2 * milkshakes <= 21, "c10")
    m.addConstr(2 * cheeseburgers + 3 * tomatoes <= 44, "c11")
    m.addConstr(3 * tomatoes**2 + 9 * milkshakes**2 <= 20, "c12")
    m.addConstr(2 * cheeseburgers**2 + 3 * tomatoes**2 + 9 * milkshakes**2 <= 28, "c13")
    m.addConstr(2 * cheeseburgers + 3 * tomatoes + 9 * milkshakes <= 28, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
