
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="cheeseburgers", vtype=gurobi.GRB.INTEGER, lb=0)
x1 = m.addVar(name="tomatoes", lb=0)
x2 = m.addVar(name="milkshakes", vtype=gurobi.GRB.INTEGER, lb=0)

# Objective function
m.setObjective(x0**2 + x0*x2 + 9*x1**2 + 4*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(12*x0 + x1 + 11*x2 <= 66, name="calcium")
m.addConstr(7*x0 + 6*x1 + 2*x2 <= 55, name="fiber")
m.addConstr(2*x0 + 3*x1 + 9*x2 <= 62, name="fat")
m.addConstr(6*x1 + 2*x2 >= 15, name="fiber_from_tomatoes_and_milkshakes")
m.addConstr(x1 + 11*x2 <= 46, name="calcium_from_tomatoes_and_milkshakes")
m.addConstr(12*x0 + x1 <= 25, name="calcium_from_cheeseburgers_and_tomatoes")
m.addConstr(12*x0 + x1 + 11*x2 <= 25, name="total_calcium")
m.addConstr(7*x0 + 6*x1 <= 23, name="fiber_from_cheeseburgers_and_tomatoes")
m.addConstr(7*x0 + 2*x2 <= 41, name="fiber_from_cheeseburgers_and_milkshakes")
m.addConstr(49*x0**2 + 36*x1**2 + 4*x2**2 <= 441, name="fiber_squared")
m.addConstr(7*x0 + 6*x1 + 2*x2 <= 21, name="total_fiber")
m.addConstr(2*x0 + 3*x1 <= 44, name="fat_from_cheeseburgers_and_tomatoes")
m.addConstr(9*x1**2 + 81*x2**2 <= 400, name="fat_squared_tomatoes_milkshakes")
m.addConstr(4*x0**2 + 9*x1**2 + 81*x2**2 <= 784, name="fat_squared")
m.addConstr(2*x0 + 3*x1 + 9*x2 <= 28, name="total_fat")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cheeseburgers: ", x0.varValue)
    print("Tomatoes: ", x1.varValue)
    print("Milkshakes: ", x2.varValue)
else:
    print("The model is infeasible")
