
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_labor_cost")

# Create variables
ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
bill = m.addVar(vtype=gp.GRB.INTEGER, name="bill")
jean = m.addVar(vtype=gp.GRB.INTEGER, name="jean")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")
peggy = m.addVar(vtype=gp.GRB.INTEGER, name="peggy")
john = m.addVar(vtype=gp.GRB.INTEGER, name="john")
mary = m.addVar(vtype=gp.GRB.INTEGER, name="mary")


# Set objective function
m.setObjective(7*ringo + 4*hank + 9*bill + 5*jean + 4*george + 3*peggy + 8*john + 6*mary, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*bill + 6*jean >= 28)
m.addConstr(14*ringo + 6*jean >= 24)
m.addConstr(14*ringo + 2*mary >= 11)
m.addConstr(8*john + 2*mary >= 21)
m.addConstr(18*hank + 8*bill >= 17)
m.addConstr(6*jean + 17*george >= 12)
m.addConstr(14*ringo + 17*george >= 31)
m.addConstr(17*george + 13*peggy >= 17)
m.addConstr(8*bill + 8*john >= 13)
m.addConstr(14*ringo + 18*hank + 8*bill + 6*jean + 17*george + 13*peggy + 8*john + 2*mary >= 13)
m.addConstr(-10*jean + 3*mary >= 0)
m.addConstr(-2*john + 8*mary >= 0)
m.addConstr(-1*bill + 1*george >= 0)
m.addConstr(6*jean + 17*george <= 122)
m.addConstr(6*jean + 8*john <= 55)
m.addConstr(8*bill + 8*john <= 72)
m.addConstr(14*ringo + 6*jean <= 191)
m.addConstr(14*ringo + 2*mary <= 103)
m.addConstr(18*hank + 2*mary <= 153)
m.addConstr(8*bill + 13*peggy <= 84)
m.addConstr(8*bill + 13*peggy + 8*john <= 187)
m.addConstr(18*hank + 6*jean + 2*mary <= 95)
m.addConstr(6*jean + 8*john + 2*mary <= 131)
m.addConstr(14*ringo + 6*jean + 13*peggy <= 201)
m.addConstr(14*ringo + 6*jean + 8*john <= 87)
m.addConstr(17*george + 13*peggy + 8*john <= 88)
m.addConstr(18*hank + 8*john + 2*mary <= 124)
m.addConstr(14*ringo + 18*hank + 17*george <= 108)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('The problem is unbounded or something else happened.')

