
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
    x4 = model.addVar(name='x4', vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
    x5 = model.addVar(name='x5', vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x6 = model.addVar(name='x6', vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x7 = model.addVar(name='x7', vtype=gurobi.GRB.INTEGER)  # hours worked by John
    x8 = model.addVar(name='x8', vtype=gurobi.GRB.INTEGER)  # hours worked by Mary

    # Define the objective function
    model.setObjective(7 * x1 + 4 * x2 + 9 * x3 + 5 * x4 + 4 * x5 + 3 * x6 + 8 * x7 + 6 * x8, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8 * x3 + 6 * x4 >= 28)
    model.addConstr(14 * x1 + 6 * x4 >= 24)
    model.addConstr(14 * x1 + 2 * x8 >= 11)
    model.addConstr(8 * x7 + 2 * x8 >= 21)
    model.addConstr(18 * x2 + 8 * x3 >= 17)
    model.addConstr(6 * x4 + 17 * x5 >= 12)
    model.addConstr(14 * x1 + 17 * x5 >= 31)
    model.addConstr(17 * x5 + 13 * x6 >= 17)
    model.addConstr(8 * x3 + 8 * x7 >= 13)
    model.addConstr(x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 >= 13)
    model.addConstr(-10 * x4 + 3 * x8 >= 0)
    model.addConstr(-2 * x7 + 8 * x8 >= 0)
    model.addConstr(-x3 + x5 >= 0)
    model.addConstr(6 * x4 + 17 * x5 <= 122)
    model.addConstr(6 * x4 + 8 * x7 <= 55)
    model.addConstr(8 * x3 + 8 * x7 <= 72)
    model.addConstr(14 * x1 + 6 * x4 <= 191)
    model.addConstr(14 * x1 + 2 * x8 <= 103)
    model.addConstr(18 * x2 + 2 * x8 <= 153)
    model.addConstr(8 * x3 + 13 * x6 <= 84)
    model.addConstr(8 * x3 + 13 * x6 + 8 * x7 <= 187)
    model.addConstr(18 * x2 + 6 * x4 + 2 * x8 <= 95)
    model.addConstr(6 * x4 + 8 * x7 + 2 * x8 <= 131)
    model.addConstr(14 * x1 + 6 * x4 + 13 * x6 <= 201)
    model.addConstr(14 * x1 + 6 * x4 + 8 * x7 <= 87)
    model.addConstr(17 * x5 + 13 * x6 + 8 * x7 <= 88)
    model.addConstr(18 * x2 + 8 * x7 + 2 * x8 <= 124)
    model.addConstr(14 * x1 + 18 * x2 + 17 * x5 <= 108)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
        print('x5: ', x5.varValue)
        print('x6: ', x6.varValue)
        print('x7: ', x7.varValue)
        print('x8: ', x8.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
