
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
kiwis = m.addVar(lb=0, name="kiwis")
ravioli = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ravioli")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken_breasts")
eggs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="eggs")

# Set objective function
m.setObjective(9.26 * kiwis * ravioli + 3.05 * ravioli**2 + 6.13 * ravioli * chicken_breasts + 6.89 * chicken_breasts * eggs + 1.11 * kiwis + 4.88 * ravioli + 2.9 * eggs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17.32 * ravioli + 11.73 * eggs >= 27)
m.addConstr(20.28 * kiwis**2 + 17.32 * ravioli**2 >= 43)
m.addConstr(20.28 * kiwis + 6.53 * chicken_breasts + 11.73 * eggs >= 36)
m.addConstr(20.28 * kiwis**2 + 17.32 * ravioli**2 + 6.53 * chicken_breasts**2 >= 36)
m.addConstr(20.28 * kiwis + 6.53 * chicken_breasts + 11.73 * eggs >= 37)
m.addConstr(20.28 * kiwis + 17.32 * ravioli + 6.53 * chicken_breasts >= 37)
m.addConstr(20.28 * kiwis + 17.32 * ravioli + 6.53 * chicken_breasts + 11.73 * eggs >= 37)
m.addConstr(2.43 * chicken_breasts**2 + 16.76 * eggs**2 >= 113)
m.addConstr(14.99 * kiwis + 2.43 * chicken_breasts >= 57)
m.addConstr(14.99 * kiwis**2 + 16.76 * eggs**2 >= 88)
m.addConstr(1.83 * ravioli + 16.76 * eggs >= 62)
m.addConstr(14.99 * kiwis + 1.83 * ravioli + 2.43 * chicken_breasts + 16.76 * eggs >= 62)
m.addConstr(18.86 * kiwis + 17.25 * ravioli >= 114)
m.addConstr(17.25 * ravioli + 7.38 * chicken_breasts >= 85)
m.addConstr(18.86 * kiwis**2 + 2.54 * eggs**2 >= 132)
m.addConstr(18.86 * kiwis + 17.25 * ravioli + 7.38 * chicken_breasts + 2.54 * eggs >= 132)
m.addConstr(20.36 * kiwis + 6.39 * ravioli >= 71)
m.addConstr(20.36 * kiwis**2 + 7.12 * chicken_breasts**2 >= 78)
m.addConstr(20.36 * kiwis**2 + 1.23 * eggs**2 >= 45)
m.addConstr(7.12 * chicken_breasts + 1.23 * eggs >= 102)
m.addConstr(6.39 * ravioli + 7.12 * chicken_breasts >= 91)
m.addConstr(6.39 * ravioli + 1.23 * eggs >= 41)
m.addConstr(20.36 * kiwis + 6.39 * ravioli + 7.12 * chicken_breasts + 1.23 * eggs >= 41)
m.addConstr(5.32 * ravioli**2 + 7.03 * eggs**2 >= 30)
m.addConstr(7.87 * kiwis + 5.32 * ravioli >= 41)
m.addConstr(4.97 * chicken_breasts + 7.03 * eggs >= 61)
m.addConstr(7.87 * kiwis + 4.97 * chicken_breasts >= 68)
m.addConstr(7.87 * kiwis**2 + 7.03 * eggs**2 >= 46)
m.addConstr(7.87 * kiwis + 5.32 * ravioli + 4.97 * chicken_breasts + 7.03 * eggs >= 46)
m.addConstr(-2 * ravioli**2 + 8 * eggs**2 >= 0)
m.addConstr(-ravioli + 3 * chicken_breasts >= 0)
m.addConstr(17.32 * ravioli + 11.73 * eggs <= 57)
m.addConstr(20.28 * kiwis + 17.32 * ravioli <= 92)
m.addConstr(14.99 * kiwis + 16.76 * eggs <= 520)
m.addConstr(2.43 * chicken_breasts**2 + 16.76 * eggs**2 <= 237)
m.addConstr(14.99 * kiwis + 1.83 * ravioli <= 276)
m.addConstr(18.86 * kiwis + 7.38 * chicken_breasts <= 315)
m.addConstr(18.86 * kiwis + 2.54 * eggs <= 521)
m.addConstr(18.86 * kiwis + 17.25 * ravioli + 2.54 * eggs <= 269)
m.addConstr(18.86 * kiwis + 17.25 * ravioli + 7.38 * chicken_breasts <= 496)
m.addConstr(18.86 * kiwis**2 + 7.38 * chicken_breasts**2 + 2.54 * eggs**2 <= 149)
m.addConstr(17.25 * ravioli**2 + 7.38 * chicken_breasts**2 + 2.54 * eggs**2 <= 559)
m.addConstr(20.36 * kiwis**2 + 7.12 * chicken_breasts**2 <= 309)
m.addConstr(5.32 * ravioli + 4.97 * chicken_breasts + 7.03 * eggs <= 94)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
