
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_B12")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_D")
    x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_C")


    # Set objective function
    m.setObjective(9.26 * x0 + 9.94 * x1 + 6.7 * x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x1 + 7 * x2 >= 31, "c1")
    m.addConstr(-5 * x1 + 6 * x2 >= 0, "c2")
    m.addConstr(x0 + 7 * x2 <= 130, "c3")
    m.addConstr(x0 + x1 <= 71, "c4")
    m.addConstr(x0 + x1 + 7 * x2 <= 174, "c5")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin B12: %g' % x0.x)
        print('Vitamin D: %g' % x1.x)
        print('Vitamin C: %g' % x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

