
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="vitamin_B12", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="vitamin_D", lb=0)    # Assuming non-negative
    x3 = model.addVar(name="vitamin_C", lb=0)    # Assuming non-negative

    # Define the objective function
    model.setObjective(9.26 * x1 + 9.94 * x2 + 6.7 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 + 7 * x3 >= 31)
    model.addConstr(-5 * x2 + 6 * x3 >= 0)
    model.addConstr(x1 + 7 * x3 <= 130)
    model.addConstr(x1 + x2 <= 71)
    model.addConstr(x1 + x2 + 7 * x3 <= 174)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Milligrams of vitamin C: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
