
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")
bill = m.addVar(vtype=gp.GRB.INTEGER, name="bill")
bobby = m.addVar(vtype=gp.GRB.INTEGER, name="bobby")
dale = m.addVar(vtype=gp.GRB.INTEGER, name="dale")


# Set objective function
m.setObjective(2.05 * hank + 2.12 * paul + 6.04 * bill + 4.16 * bobby + 8.25 * dale, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(29 * paul + 28 * bobby >= 44)
m.addConstr(22 * hank + 8 * bill >= 99)
m.addConstr(28 * bobby + 17 * dale >= 54)
m.addConstr(8 * bill + 28 * bobby >= 82)
m.addConstr(29 * paul + 8 * bill >= 91)
m.addConstr(22 * hank + 29 * paul >= 53)

# ... (rest of the paperwork competence constraints)

m.addConstr(6 * hank + 1 * bobby >= 75)
m.addConstr(18 * paul + 23 * bill >= 146)
m.addConstr(6 * hank + 10 * dale >= 123)

# ... (rest of the computer competence constraints)


m.addConstr(hank - 9 * dale >= 0)
m.addConstr(8 * bill + 17 * dale <= 533)
m.addConstr(29 * paul + 8 * bill <= 355)

# ... (rest of the upper bound constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('hank:', hank.x)
    print('paul:', paul.x)
    print('bill:', bill.x)
    print('bobby:', bobby.x)
    print('dale:', dale.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

