
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(4, lb=0, name=["Bill", "Dale", "John", "Hank"])


# Set objective function
m.setObjective(3*x[0] + 8*x[1] + 6*x[2] + x[3], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9.48*x[1] + 3.21*x[3] >= 51)
m.addConstr(7.1*x[0] + 6.37*x[2] >= 65)
m.addConstr(6.37*x[2] + 3.21*x[3] >= 103)
m.addConstr(7.1*x[0] + 9.48*x[1] + 3.21*x[3] >= 60)
m.addConstr(4.6*x[1] + 3.76*x[3] >= 64)
m.addConstr(3.61*x[2] + 3.76*x[3] >= 41)
m.addConstr(9.28*x[0] + 3.61*x[2] >= 36)
m.addConstr(9.28*x[0] + 4.6*x[1] + 3.76*x[3] >= 51)
m.addConstr(9.28*x[0] + 3.61*x[2] + 3.76*x[3] >= 51)
m.addConstr(4.6*x[1] + 3.61*x[2] + 3.76*x[3] >= 51)
m.addConstr(9.28*x[0] + 4.6*x[1] + 3.76*x[3] >= 72)
m.addConstr(9.28*x[0] + 3.61*x[2] + 3.76*x[3] >= 72)
m.addConstr(4.6*x[1] + 3.61*x[2] + 3.76*x[3] >= 72)
m.addConstr(4.65*x[0] + 9.13*x[1] >= 47)
m.addConstr(4.65*x[0] + 4.87*x[3] >= 52)
m.addConstr(4.65*x[0] + 9.13*x[1] + 1.4*x[2] >= 58)
m.addConstr(3.94*x[0] + 8.66*x[3] >= 60)
m.addConstr(2.01*x[1] + 3.3*x[2] >= 37)
m.addConstr(-9*x[0] + 5*x[2] + 4*x[3] >= 0)
m.addConstr(7.1*x[0] + 6.37*x[2] <= 388)
m.addConstr(7.1*x[0] + 9.48*x[1] <= 266)
m.addConstr(9.48*x[1] + 6.37*x[2] <= 275)
m.addConstr(7.1*x[0] + 3.21*x[3] <= 373)
m.addConstr(7.1*x[0] + 6.37*x[2] + 3.21*x[3] <= 117)
m.addConstr(7.1*x[0] + 9.48*x[1] + 3.21*x[3] <= 176)
m.addConstr(7.1*x[0] + 9.48*x[1] + 6.37*x[2] <= 363)
m.addConstr(7.1*x[0] + 9.48*x[1] + 6.37*x[2] + 3.21*x[3] <= 363)
m.addConstr(9.28*x[0] + 3.61*x[2] <= 145)
m.addConstr(4.6*x[1] + 3.61*x[2] <= 215)
m.addConstr(4.6*x[1] + 3.76*x[3] <= 268)
m.addConstr(9.28*x[0] + 3.76*x[3] <= 306)
m.addConstr(9.28*x[0] + 4.6*x[1] + 3.61*x[2] <= 179)
m.addConstr(4.6*x[1] + 3.61*x[2] + 3.76*x[3] <= 165)
m.addConstr(9.28*x[0] + 4.6*x[1] + 3.61*x[2] + 3.76*x[3] <= 165)
m.addConstr(4.65*x[0] + 4.87*x[3] <= 129)
m.addConstr(1.4*x[2] + 4.87*x[3] <= 152)
m.addConstr(4.65*x[0] + 9.13*x[1] <= 241)
m.addConstr(4.65*x[0] + 1.4*x[2] + 4.87*x[3] <= 154)
m.addConstr(4.65*x[0] + 9.13*x[1] + 1.4*x[2] + 4.87*x[3] <= 154)
m.addConstr(3.94*x[0] + 3.3*x[2] <= 70)
m.addConstr(3.94*x[0] + 2.01*x[1] <= 226)
m.addConstr(3.94*x[0] + 8.66*x[3] <= 123)
m.addConstr(2.01*x[1] + 3.3*x[2] <= 244)
m.addConstr(2.01*x[1] + 8.66*x[3] <= 169)
m.addConstr(3.94*x[0] + 2.01*x[1] + 3.3*x[2] + 8.66*x[3] <= 169)
m.addConstr(7.53*x[0] + 3.41*x[2] <= 486)
m.addConstr(7.53*x[0] + 2.29*x[1] <= 447)
m.addConstr(2.29*x[1] + 5.1*x[3] <= 136)
m.addConstr(7.53*x[0] + 5.1*x[3] <= 473)
m.addConstr(2.29*x[1] + 3.41*x[2] <= 400)
m.addConstr(7.53*x[0] + 3.41*x[2] + 5.1*x[3] <= 514)
m.addConstr(7.53*x[0] + 2.29*x[1] + 5.1*x[3] <= 442)
m.addConstr(7.53*x[0] + 2.29*x[1] + 3.41*x[2] + 5.1*x[3] <= 442)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

