
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("minimize_work_hours")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_John")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Bobby")


    # Set objective function
    model.setObjective(9*x0 + 6*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1*x0 + 1*x1 >= 21, "productivity_rating_constraint")
    model.addConstr(6*x0 + 9*x1 >= 24, "computer_competence_rating_constraint")
    model.addConstr(-7*x0 + 4*x1 >= 0, "constraint3")
    model.addConstr(1*x0 + 1*x1 <= 56, "constraint4")
    model.addConstr(6*x0 + 9*x1 <= 42, "constraint5")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by John: {x0.x}")
        print(f"Hours worked by Bobby: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
