
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(9*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 21, "productivity_rating")
m.addConstr(6*x1 + 9*x2 >= 24, "computer_competence_rating_min")
m.addConstr(-7*x1 + 4*x2 >= 0, "other_constraint")
m.addConstr(x1 + x2 <= 56, "productivity_rating_max")
m.addConstr(6*x1 + 9*x2 <= 42, "computer_competence_rating_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by John:", x1.x)
    print("Hours worked by Bobby:", x2.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
