
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_John", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(9 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 >= 21, name="productivity_rating_constraint")
    model.addConstr(6 * x1 + 9 * x2 >= 24, name="computer_competence_rating_constraint")
    model.addConstr(-7 * x1 + 4 * x2 >= 0, name="linear_constraint")
    model.addConstr(x1 + x2 <= 56, name="upper_bound_productivity_constraint")
    model.addConstr(6 * x1 + 9 * x2 <= 42, name="upper_bound_computer_competence_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by John: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
