
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    honeypots = model.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
    network_admins = model.addVar(vtype=gp.GRB.INTEGER, name="network_admins")
    patches_per_day = model.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")

    # Set objective function
    model.setObjective(2.27 * honeypots + 8.46 * network_admins + 3.88 * patches_per_day, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(12 * honeypots + 12 * patches_per_day >= 92)
    model.addConstr(20 * honeypots + 4 * patches_per_day >= 84)
    model.addConstr(20 * honeypots + 12 * patches_per_day >= 38)
    model.addConstr(12 * honeypots + 12 * patches_per_day <= 216)
    model.addConstr(12 * honeypots + 18 * network_admins <= 265)
    model.addConstr(12 * honeypots + 18 * network_admins + 12 * patches_per_day <= 265)
    model.addConstr(20 * honeypots + 20 * network_admins <= 175)
    model.addConstr(20 * network_admins + 4 * patches_per_day <= 132)
    model.addConstr(20 * honeypots + 4 * patches_per_day <= 131)
    model.addConstr(20 * honeypots + 20 * network_admins + 4 * patches_per_day <= 131)
    model.addConstr(12 * network_admins + 12 * patches_per_day <= 111)
    model.addConstr(20 * honeypots + 12 * network_admins <= 111)
    model.addConstr(20 * honeypots + 12 * network_admins + 12 * patches_per_day <= 115)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('honeypots:', honeypots.x)
        print('network_admins:', network_admins.x)
        print('patches_per_day:', patches_per_day.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
