
import gurobipy as gp

# Create a new model
model = gp.Model("resource_allocation")

# Create variables
patches_per_day = model.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
system_administrators = model.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
deployed_decoys = model.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")
pen_testers = model.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
soc_operators = model.addVar(vtype=gp.GRB.INTEGER, name="soc_operators")
security_engineers = model.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")


# Set objective function
model.setObjective(9 * patches_per_day + 3 * system_administrators + 7 * deployed_decoys + 8 * pen_testers + 4 * soc_operators + 8 * security_engineers, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(18 * patches_per_day + 9 * system_administrators + 9 * deployed_decoys + 24 * pen_testers + 22 * soc_operators + 8 * security_engineers <= 376, "r0")
model.addConstr(1 * patches_per_day + 7 * system_administrators + 2 * deployed_decoys + 21 * pen_testers + 18 * soc_operators + 25 * security_engineers <= 321, "r1")
model.addConstr(20 * patches_per_day + 16 * system_administrators + 20 * deployed_decoys + 25 * pen_testers + 5 * soc_operators + 25 * security_engineers <= 694, "r2")


# ... (The rest of the constraints from the JSON "constraints" field would be added here similarly)

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

