
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="patches_per_day", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="deployed_decoys", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="pen_testers", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="SOC_operators", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="security_engineers", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(9*x0 + 3*x1 + 7*x2 + 8*x3 + 4*x4 + 8*x5, gp.GRB.MAXIMIZE)

# Add constraints
# Data accessibility impact constraints
m.addConstr(18*x0 + 9*x1 + 9*x2 + 24*x3 + 22*x4 + 8*x5 >= 42)
m.addConstr(18*x0 + 9*x1 + 9*x2 + 24*x3 + 8*x5 >= 42)
m.addConstr(9*x1 + 9*x2 + 8*x5 >= 42)

# Network latency constraints
m.addConstr(x0 + 7*x1 >= 37)
m.addConstr(x0 + 21*x3 >= 30)
m.addConstr(7*x1 + 25*x5 >= 17)

# Cost constraints
m.addConstr(20*x2 + 25*x5 >= 79)
m.addConstr(16*x1 + 25*x3 >= 60)
m.addConstr(20*x2 + 20*x3 >= 40)

# Bounds
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x4 >= 0)
m.addConstr(x5 >= 0)

# Resource constraints
m.addConstr(18*x0 + 9*x1 + 9*x2 + 24*x3 + 22*x4 + 8*x5 <= 376)
m.addConstr(x0 + 7*x1 + 2*x2 + 21*x3 + 18*x4 + 25*x5 <= 321)
m.addConstr(20*x0 + 16*x1 + 20*x2 + 25*x3 + 5*x4 + 25*x5 <= 694)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("patches per day: ", x0.varValue)
    print("system administrators: ", x1.varValue)
    print("deployed decoys: ", x2.varValue)
    print("pen testers: ", x3.varValue)
    print("SOC operators: ", x4.varValue)
    print("security engineers: ", x5.varValue)
else:
    print("The model is infeasible")
