
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("diet_problem")

    # Create variables
    corn_cobs = m.addVar(vtype=gp.GRB.INTEGER, name="corn_cobs")
    chicken_breasts = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_breasts")


    # Set objective function
    m.setObjective(3 * corn_cobs + 7 * chicken_breasts, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(17 * corn_cobs + 4 * chicken_breasts >= 16, "fat_min")
    m.addConstr(22 * corn_cobs + 18 * chicken_breasts >= 52, "carbs_min")
    m.addConstr(-7 * corn_cobs + 10 * chicken_breasts >= 0, "corn_chicken_ratio")
    m.addConstr(17 * corn_cobs + 4 * chicken_breasts <= 69, "fat_max")
    m.addConstr(22 * corn_cobs + 18 * chicken_breasts <= 210, "carbs_max")

    # Resource constraints (upper bounds based on provided data)
    m.addConstr(17 * corn_cobs <= 80, "fat_resource_limit_corn")
    m.addConstr(4 * chicken_breasts <= 80, "fat_resource_limit_chicken")
    m.addConstr(22 * corn_cobs <= 227, "carb_resource_limit_corn")
    m.addConstr(18 * chicken_breasts <= 227, "carb_resource_limit_chicken")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('corn_cobs:', corn_cobs.x)
        print('chicken_breasts:', chicken_breasts.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
