
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")
x2 = m.addVar(vtype=GRB.INTEGER, name="chicken_breasts")

# Set the objective function
m.setObjective(3*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x1 + 4*x2 >= 16, "fat_min")
m.addConstr(22*x1 + 18*x2 >= 52, "carbs_min")
m.addConstr(-7*x1 + 10*x2 >= 0, "min_constraint")
m.addConstr(17*x1 + 4*x2 <= 69, "fat_max")
m.addConstr(22*x1 + 18*x2 <= 210, "carbs_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
