
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='corn_cobs', vtype=gurobi.GRB.INTEGER)  # corn cobs
x2 = m.addVar(name='chicken_breasts', vtype=gurobi.GRB.INTEGER)  # chicken breasts

# Objective function
m.setObjective(3*x1 + 7*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(17*x1 + 4*x2 >= 16, name='fat_min')
m.addConstr(22*x1 + 18*x2 >= 52, name='carb_min')
m.addConstr(-7*x1 + 10*x2 >= 0, name='linear_constraint')
m.addConstr(17*x1 + 4*x2 <= 69, name='fat_max')
m.addConstr(22*x1 + 18*x2 <= 210, name='carb_max')

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Corn cobs: ', x1.varValue)
    print('Chicken breasts: ', x2.varValue)
else:
    print('The model is infeasible')
