
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Resource_Allocation")

    # Create variables
    ringo_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")
    paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")


    # Set objective function
    model.setObjective(9 * ringo_hours + 3 * paul_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * ringo_hours + 1 * paul_hours >= 22, "c0")
    model.addConstr(9 * ringo_hours + 1 * paul_hours >= 9, "c1")
    model.addConstr(5 * ringo_hours + 3 * paul_hours >= 28, "c2")
    model.addConstr(3 * ringo_hours + 4 * paul_hours >= 10, "c3")
    model.addConstr(-5 * ringo_hours + 10 * paul_hours >= 0, "c4")
    model.addConstr(4 * ringo_hours + 1 * paul_hours <= 36, "c5")
    model.addConstr(9 * ringo_hours + 1 * paul_hours <= 35, "c6")
    model.addConstr(5 * ringo_hours + 3 * paul_hours <= 38, "c7")
    model.addConstr(3 * ringo_hours + 4 * paul_hours <= 34, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Ringo Hours: %g' % ringo_hours.x)
        print('Paul Hours: %g' % paul_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
