
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Ringo", lb=0)  # hours worked by Ringo
    x1 = model.addVar(name="hours_worked_by_Paul", lb=0)   # hours worked by Paul

    # Define the objective function
    model.setObjective(9 * x0 + 3 * x1, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(4 * x0 + x1 >= 22, name="computer_competence_rating")
    model.addConstr(9 * x0 + x1 >= 9, name="productivity_rating")
    model.addConstr(5 * x0 + 3 * x1 >= 28, name="paperwork_competence_rating")
    model.addConstr(3 * x0 + 4 * x1 >= 10, name="likelihood_to_quit_index")
    model.addConstr(-5 * x0 + 10 * x1 >= 0, name="ratio_constraint")
    model.addConstr(4 * x0 + x1 <= 36, name="computer_competence_rating_upper_bound")
    model.addConstr(9 * x0 + x1 <= 35, name="productivity_rating_upper_bound")
    model.addConstr(5 * x0 + 3 * x1 <= 38, name="paperwork_competence_rating_upper_bound")
    model.addConstr(3 * x0 + 4 * x1 <= 34, name="likelihood_to_quit_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Ringo: {x0.varValue}")
        print(f"Hours worked by Paul: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
