
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
    toilet_paper_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper_rolls")
    candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
    rubber_gloves = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
    dish_soap_bottles = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")

    # Set objective function
    m.setObjective(2*diapers + 5*toilet_paper_rolls + 8*candles + 6*rubber_gloves + 5*dish_soap_bottles, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*toilet_paper_rolls + 11*candles >= 26)
    m.addConstr(3*diapers + 11*rubber_gloves >= 43)
    m.addConstr(11*candles + 11*rubber_gloves >= 16)
    m.addConstr(11*candles + 12*dish_soap_bottles >= 39)
    m.addConstr(2*toilet_paper_rolls + 12*dish_soap_bottles >= 31)
    m.addConstr(2*toilet_paper_rolls + 11*rubber_gloves >= 40)
    m.addConstr(3*diapers + 2*toilet_paper_rolls >= 20)
    m.addConstr(2*toilet_paper_rolls + 11*candles <= 121)
    m.addConstr(3*diapers + 2*toilet_paper_rolls <= 100)
    m.addConstr(3*diapers + 11*candles <= 62)
    m.addConstr(3*diapers + 2*toilet_paper_rolls + 11*rubber_gloves <= 88)
    m.addConstr(3*diapers + 11*rubber_gloves + 12*dish_soap_bottles <= 179)
    m.addConstr(3*diapers + 2*toilet_paper_rolls + 12*dish_soap_bottles <= 69)
    m.addConstr(3*diapers + 2*toilet_paper_rolls + 11*candles <= 152)
    m.addConstr(2*toilet_paper_rolls + 11*candles + 12*dish_soap_bottles <= 150)
    m.addConstr(3*diapers + 2*toilet_paper_rolls + 11*candles + 11*rubber_gloves + 12*dish_soap_bottles <= 150)
    m.addConstr(3*diapers + 2*toilet_paper_rolls + 11*candles + 11*rubber_gloves + 12*dish_soap_bottles <= 216)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
